#! /usr/bin/env python
"""Merge elements of two transcript lists with some condition"""

import os
from optparse import OptionParser
from parsing.sequenceListParser import *
from parsing.bedParser import *
from parsing.gffParser import *
from writer.transcriptWriter import *
from structure.transcriptListsComparator import *
from misc.rPlotter import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Merge Lists: Merge the elements of two lists of genomic coordinates. [Category: Merge]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input1",    dest="inputFileName1", action="store",                     type="string", help="input file 1 [compulsory] [format: file in transcript format given by -f]")
  parser.add_option("-f", "--format1",   dest="format1",        action="store",                     type="string", help="format of file 1 [compulsory] [format: transcript file format]")
  parser.add_option("-j", "--input2",    dest="inputFileName2", action="store",      default=None,  type="string", help="input file 2 [compulsory] [format: file in transcript format given by -g]")
  parser.add_option("-g", "--format2",   dest="format2",        action="store",      default=None,  type="string", help="format of file 2 [compulsory] [format: file in transcript format]")
  parser.add_option("-o", "--output",    dest="outputFileName", action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-k", "--all",       dest="all",            action="store_true", default=False,                help="print all the transcripts, not only those overlapping [format: bool] [default: false]")
  parser.add_option("-d", "--distance",  dest="distance",       action="store",      default=0,     type="int",    help="max. distance between two transcripts [format: int] [default: 0]")
  parser.add_option("-a", "--antisense", dest="antisense",      action="store_true", default=False,                help="antisense only [format: bool] [default: false]")
  parser.add_option("-c", "--colinear",  dest="colinear",       action="store_true", default=False,                help="colinear only [format: bool] [default: false]")
  parser.add_option("-s", "--start1",    dest="start1",         action="store",      default=None,  type="int",    help="only consider start for list 1 [format: int]")
  parser.add_option("-S", "--start2",    dest="start2",         action="store",      default=None,  type="int",    help="only consider start for list 2 [format: int]")
  parser.add_option("-t", "--extend1",   dest="extend1",        action="store",      default=None,  type="int",    help="extend elements from list 1 by n nucleotides in the 5' direction [format: int]")
  parser.add_option("-T", "--extend2",   dest="extend2",        action="store",      default=None,  type="int",    help="extend elements from list 2 by n nucleotides in the 5' direction [format: int]")
  parser.add_option("-y", "--mysql",     dest="mysql",          action="store_true", default=False,                help="store into mySQL table [format: bool] [default: false]")
  parser.add_option("-v", "--verbosity", dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",       dest="log",            action="store_true", default=False,                help="write a log file [format: bool] [default: false]")
  (options, args) = parser.parse_args()

  logHandle = None
  if options.log:
    logHandle = open("%s.log" % options.outputFileName, "w")
  
  transcriptListComparator = TranscriptListsComparator(logHandle, options.verbosity)
  transcriptListComparator.getAntisenseOnly(options.antisense)
  transcriptListComparator.getColinearOnly(options.colinear)
  transcriptListComparator.restrictToStart(transcriptListComparator.QUERY, options.start1)
  transcriptListComparator.restrictToStart(transcriptListComparator.REFERENCE, options.start2)
  transcriptListComparator.extendFivePrime(transcriptListComparator.QUERY, options.extend1)
  transcriptListComparator.extendFivePrime(transcriptListComparator.REFERENCE, options.extend2)
  transcriptListComparator.aggregate(options.all)
  transcriptListComparator.setMaxDistance(options.distance)
  transcriptContainer1 = TranscriptContainer(options.inputFileName1, options.format1, options.verbosity)
  transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.QUERY, transcriptContainer1)
  if options.format2 == None:
    transcriptListComparator.aggregate(True)
    transcriptListComparator.compareTranscriptListSelfMerge()
  else:
    transcriptContainer2 = TranscriptContainer(options.inputFileName2, options.format2, options.verbosity)
    transcriptListComparator.setInputTranscriptContainer(transcriptListComparator.REFERENCE, transcriptContainer2)
    transcriptListComparator.compareTranscriptListMerge()
  outputContainer = transcriptListComparator.getOutputTranscripts()
  
  if options.outputFileName != None:
    writer = TranscriptWriter(options.outputFileName, "gff3", options.verbosity)
    writer.setContainer(outputContainer)
    writer.write()
    
    if options.mysql:
      writer = TranscriptWriter(options.outputFileName, "sql", options.verbosity)
      writer.setContainer(outputContainer)
      writer.write()

  if options.log:
    logHandle.close()
