#! /usr/bin/env python
"""
Test if the configuration is sound
"""

import sys
import os
import subprocess

# Test Python files
try :
  from misc.rPlotter import *
except:
  print "Cannot find Python scripts! Update PYTHONPATH (currently %s) environment variable and see configuration in the documentation!" % (os.environ["PYTHONPATH"] if "PYTHONPATH" in os.environ else "empty")
  sys.exit(3)

try :
  from mySql.mySqlTranscriptTable import *
except:
  print "MySQLdb is not installed ! Please read the documentation!"
  sys.exit(4)


if __name__ == "__main__":
  
  print "Python scripts are correctly read."
  
  # Test mySQL
  connection = MySqlConnection()
  table = MySqlTranscriptTable()

  try:
    table.createTranscriptTable()
  except:
    print "Cannot connect to the mySQL database! See configuration in the documentation!"
    sys.exit(5)
    
  print "mySQL database is correctly set up."

    
  # Test R
  fileName = "tmpFile.R"
  file = open(fileName, "w")
  file.write("?licence\n")
  file.close()
  rCommand = "R"
  if "SMARTRPATH" in os.environ:
    rCommand = os.environ["SMARTRPATH"]
  command = "\"%s\" CMD BATCH %s" % (rCommand, fileName)
  status  = subprocess.call(command, shell=True)
  os.remove(fileName)
  outputFileName = "%sout" % (fileName)
  if os.path.exists(outputFileName):
    os.remove(outputFileName)

  if status != 0:
    print "Problem with the execution of R script (command '%s' did not work, current directory is %s, status is %d)! See configuration in the documentation!" % (command, os.getcwd(), status)
    sys.exit(6)

  line = {0: 1, 1: 2}
  pngFileName = "tmpFile.png"
  plotter = RPlotter(pngFileName)
  plotter.addLine(line)
  try:
    plotter.plot()
  except:
    print "Problem with the execution of R script: library 'RColorBrewer' is missing! See configuration in the documentation!"
    sys.exit(7)
  os.remove(pngFileName)

  print "R is available."

  print "Set up is fine! Enjoy S-MART!"
