import unittest
import os
from SMART.Java.Python.mergeSlidingWindowsClusters import MergeSlidingWindowsClusters
from SMART.Java.Python.misc import Utils

class Test_F_mergeSlidingWindowsClusters(unittest.TestCase):


    def setUp(self):
        self._outputFileName = 'outputMSWC'
        self._inputFileName1 = 'inputMSWC1.gff3'
        self._inputFileName2 = 'inputMSWC2.gff3'
        self._writeInput1(self._inputFileName1)
        self._writeInput2(self._inputFileName2)
        self._expOutput = 'expOutputMSWC.gff3'
        self._writeExpOutput(self._expOutput)

    def tearDown(self):
        os.remove(self._inputFileName1)
        os.remove(self._inputFileName2)
        os.remove(self._outputFileName+'.gff3')
        os.remove(self._expOutput)


    def test_run(self):
        iMSWC = MergeSlidingWindowsClusters(0)
        iMSWC.addInput(self._inputFileName1, 'gff3')
        iMSWC.addInput(self._inputFileName2, 'gff3')
        iMSWC.setOutput(self._outputFileName)
        iMSWC.merge()
        self.assertTrue(Utils.diff(self._outputFileName+'.gff3', self._expOutput))
        
    def test_run_asScript(self):
        cmd = 'python ../mergeSlidingWindowsClusters.py -i %s -f gff3 -j %s -g gff3 -o outputMSWC.gff3 --galaxy -v 0' % (self._inputFileName1, self._inputFileName2)
        os.system(cmd)
        self.assertTrue(Utils.diff(self._outputFileName+'.gff3', self._expOutput)) 
        
    def _writeInput1(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\ttest\tmatch\t6155418\t6155441\t24\t+\t.\tName=test1/1;occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100\n")
        f.write("chr2\ttest\tmatch\t26303950\t26303981\t32\t+\t.\tName=test2/1;occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93\n")
        f.write("chr3\ttest\tmatch\t28320540\t28320574\t35\t+\t.\tName=test2/1;occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94\n")
        f.write("chr4\ttest\tmatch\t28565007\t28565041\t35\t+\t.\tName=test2/1;occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88\n")
        f.write("chr6\ttest\tmatch\t48565007\t48565041\t35\t+\t.\tName=test2/1;occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=3;ID=test2/1-4;identity=80\n")
        f.close()

    def _writeInput2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\ttest\tmatch\t6155418\t6155441\t24\t+\t.\tName=test1/1;occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100\n")
        f.write("chr2\ttest\tmatch\t26303990\t26304021\t32\t+\t.\tName=test2/1;occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93\n")
        f.write("chr3\ttest\tmatch\t28320540\t28320574\t35\t+\t.\tName=test2/1;occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94\n")
        f.write("chr4\ttest\tmatch\t28565017\t28565051\t35\t+\t.\tName=test2/1;occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88\n")
        f.write("chr5\ttest\tmatch\t30000000\t30000050\t50\t+\t.\tName=test3/1;occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=1;ID=test3/1-4;identity=50\n")
        f.close()   
        
    def _writeExpOutput(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr6	S-MART	match	48565007	48565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=3;ID=test2/1-4;identity=80;Name=region_1
chr5	S-MART	match	30000000	30000050	50	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=1;ID=test3/1-4;identity=50;Name=region_2
chr4	S-MART	match	28565017	28565051	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=region_3
chr4	S-MART	match	28565007	28565041	35	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=region_4
chr3	S-MART	match	28320540	28320574	35	+	.	occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=region_5
chr2	S-MART	match	26303990	26304021	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=region_6
chr2	S-MART	match	26303950	26303981	32	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=region_7
chr1	S-MART	match	6155418	6155441	24	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=region_8
""")
#       f.write("chr6\tS-MART\tmatch\t48565007\t48565041\t35\t+\t.\tName=region_1;occurrence=3;feature=match;rank=3;score=35;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=3;ID=test2/1-4;identity=80\n")
#       f.write("chr5\tS-MART\tmatch\t30000000\t30000050\t50\t+\t.\tName=region_2;occurrence=3;feature=match;rank=3;score=50;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=1;ID=test3/1-4;identity=50\n")
#       f.write("chr4\tS-MART\tmatch\t28565017\t28565051\t35\t+\t.\tName=region_3;occurrence=3;feature=match;rank=3;score=35;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88\n")
#       f.write("chr4\tS-MART\tmatch\t28565007\t28565041\t35\t+\t.\tName=region_4;occurrence=3;feature=match;rank=3;score=35;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88\n")
#       f.write("chr3\tS-MART\tmatch\t28320540\t28320574\t35\t+\t.\tName=region_5;occurrence=2;feature=match;score=35;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94\n")
#       f.write("chr2\tS-MART\tmatch\t26303990\t26304021\t32\t+\t.\tName=region_6;occurrence=1;feature=match;rank=1;score=32;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93\n")
#       f.write("chr2\tS-MART\tmatch\t26303950\t26303981\t32\t+\t.\tName=region_7;occurrence=1;feature=match;rank=1;score=32;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93\n")
#       f.write("chr1\tS-MART\tmatch\t6155418\t6155441\t24\t+\t.\tName=region_8;occurrence=1;feature=match;rank=1;score=24;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100\n")
        f.close()
    
            

if __name__ == "__main__":
    unittest.main()
