import unittest
import os
from SMART.Java.Python.misc import Utils
from commons.core.utils.FileUtils import FileUtils
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim
from SMART.Java.Python.ncList.test.MockFindOverlapsWithSeveralIntervals import *

class Test_F_FindOverlapsOptim(unittest.TestCase):

    def setUp(self):
        self._inputRefGff3FileName = 'sorted_Ref.gff3'
        self._writeGFF3File(self._inputRefGff3FileName)
        self._inputQueryGff3FileName = 'sorted_Query.gff3'
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._outputGff3FileName = 'output.gff3'
        self._expOutputFileName = 'expOutGff3.gff3'
        
    def tearDown(self):
        for fileName in (self._inputRefGff3FileName, self._inputQueryGff3FileName, self._outputGff3FileName, self._expOutputFileName):
            if os.path.exists(fileName):
                os.remove(fileName)
        
    def test_run_general_asScript(self):
        cmd = 'python ../FindOverlapsOptim.py -i %s -f gff -j %s -g gff -o %s -v 0' % (self._inputQueryGff3FileName, self._inputRefGff3FileName, self._outputGff3FileName)      
        os.system(cmd)
        self._writeExpOutFile_general(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))         

    def test_run_overlap_special_case(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(self._inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_special_case(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName) 
        
    def test_run_overlap_special_case_asScript(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        cmd = 'python ../FindOverlapsOptim.py -i %s -f gff -j %s -g gff -o %s -v 0' % (inputQueryGff3FileName, self._inputRefGff3FileName, self._outputGff3FileName)      
        os.system(cmd) 
        self._writeExpOutFile_special_case(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))         
        os.remove(inputQueryGff3FileName) 
        
    def test_case_2(self):
        inputRefGff3FileName = 'ref_case2.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case2()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case2.gff3'
        self._writeQueryGff3File_case2(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case2(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName) 
        os.remove(inputRefGff3FileName) 
        
    def test_case_3(self):
        inputRefGff3FileName = 'ref_case3.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case3()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case3.gff3'
        self._writeQueryGff3File_case3(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case3(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)    
       
    def test_case_4(self):
        inputRefGff3FileName = 'ref_case4.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case4_5()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case4.gff3'
        self._writeQueryGff3File_case4(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case4(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName) 
        os.remove(inputRefGff3FileName)   
       
    def test_case_5(self):
        inputRefGff3FileName = 'ref_case5.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case4_5()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case5.gff3'
        self._writeQueryGff3File_case5(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case5(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName) 
        os.remove(inputRefGff3FileName)   
       
    def test_case_6(self):
        inputRefGff3FileName = 'ref_case6.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case6_7()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case6.gff3'
        self._writeQueryGff3File_case6(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case6(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)   
       
    def test_case_7(self):
        inputRefGff3FileName = 'ref_case7.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case6_7()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case7.gff3'
        self._writeQueryGff3File_case7(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case7(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
       
    def test_case_8(self):
        inputRefGff3FileName = 'ref_case8.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case8()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case8.gff3'
        self._writeQueryGff3File_case8(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case8(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
       
    def test_case_9(self):
        inputRefGff3FileName = 'ref_case9.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case9()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case9.gff3'
        self._writeQueryGff3File_case9(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case9(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
       
    def test_case_10(self):
        inputRefGff3FileName = 'ref_case10.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case10()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case10.gff3'
        self._writeQueryGff3File_case10(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case10(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
       
    def test_case_11(self):
        inputRefGff3FileName = 'ref_case11.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case11()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case11.gff3'
        self._writeQueryGff3File_case11(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case11(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
               
    def test_case_12(self):
        inputRefGff3FileName = 'ref_case12.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case12()
        iMock.write(inputRefGff3FileName)
        inputQueryGff3FileName = 'query_case12.gff3'
        self._writeQueryGff3File_case12(inputQueryGff3FileName)  
        iFOO = FindOverlapsOptim(0)
        iFOO.setRefFileName(inputRefGff3FileName, "gff")
        iFOO.setQueryFileName(inputQueryGff3FileName, "gff")
        iFOO.setOutputFileName(self._outputGff3FileName)
        iFOO.run()
        iFOO.close()
        self._writeExpOutFile_case12(self._expOutputFileName)        
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputGff3FileName))   
        os.remove(inputQueryGff3FileName)
        os.remove(inputRefGff3FileName)
               
    def _writeExpOutFile_special_case(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2\t1250\t1300\t781\t+\t.\tnbOverlaps=1;overlapsWith=test2.7;ID=query_2;Name=test1.2\n")
        f.close() 
        
    def _writeExpOutFile_general(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test1.1	25	150	126	+	.	nbOverlaps=3;overlapsWith=test2.1--test2.2--test2.3;ID=query_1;Name=test1.1
chr1	S-MART	test1.2	70	850	781	+	.	nbOverlaps=6;overlapsWith=test2.1--test2.2--test2.3--test2.4--test2.5--test2.6;ID=query_2;Name=test1.2
chr1	S-MART	test1.3	550	850	201	+	.	nbOverlaps=4;overlapsWith=test2.1--test2.3--test2.5--test2.6;ID=query_3;Name=test1.3
chr1	S-MART	test1.4	925	1025	101	+	.	nbOverlaps=2;overlapsWith=test2.1--test2.5;ID=query_4;Name=test1.4
chr1	S-MART	test1.5	1201	1210	10	+	.	nbOverlaps=1;overlapsWith=test2.7;ID=query_5;Name=test1.5
""")
        f.close() 

    def _writeExpOutFile_cas_1(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_3;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_3;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_3;ID=test2.6\n")
        f.close()         

    def _writeExpOutFile_cas_2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_2;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;overlapsWith=query_2;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_2;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.4\t200\t450\t251\t+\t.\tName=test2.4;overlapsWith=query_2;score=251;feature=test2.4;ID=test2.4\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_2;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_2;score=101;feature=test2.6;ID=test2.6\n")
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_3;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_3;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_3;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_3;score=101;feature=test2.6;ID=test2.6\n")
        f.close() 

    def _writeExpOutFile_all_overlap(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_2;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;overlapsWith=query_2;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_2;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.4\t200\t450\t251\t+\t.\tName=test2.4;overlapsWith=query_2;score=251;feature=test2.4;ID=test2.4\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_2;score=251;feature=test2.5;ID=test2.5\n")
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_2;score=101;feature=test2.6;ID=test2.6\n")
        f.close()           

    def _writeExpOutFile_overlap_to_children(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_3;score=1001;feature=test2.1;ID=test2.1\n") 
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_3;score=501;feature=test2.3;ID=test2.3\n") 
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_3;score=251;feature=test2.5;ID=test2.5\n") 
        f.write("chr1\tS-MART\ttest2.6\t800\t900\t101\t+\t.\tName=test2.6;overlapsWith=query_3;score=101;feature=test2.6;ID=test2.6\n") 
        f.close()         

    def _writeExpOutFile_not_overlap_to_children(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_1;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.2\t50\t350\t301\t+\t.\tName=test2.2;overlapsWith=query_1;score=301;feature=test2.2;ID=test2.2\n")
        f.write("chr1\tS-MART\ttest2.3\t100\t600\t501\t+\t.\tName=test2.3;overlapsWith=query_1;score=501;feature=test2.3;ID=test2.3\n")
        f.write("chr1\tS-MART\ttest2.1\t9\t1000\t1001\t+\t.\tName=test2.1;overlapsWith=query_4;score=1001;feature=test2.1;ID=test2.1\n")
        f.write("chr1\tS-MART\ttest2.5\t700\t950\t251\t+\t.\tName=test2.5;overlapsWith=query_4;score=251;feature=test2.5;ID=test2.5\n")
        f.close()        

    def _writeExpOutFile_no_overlap_right(self, fileName):
        f = open(fileName, 'w')
        f.close()                 

    def _writeExpOutFile_one_overlap(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tS-MART\ttest2.7\t1200\t1300\t101\t+\t.\tName=test2.7;overlapsWith=query_5;score=101;feature=test2.7;ID=test2.7\n")
        f.close()                  

    def _writeExpOutFile_case2(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test2.1	150	300	151	+	.	nbOverlaps=4;overlapsWith=test2.1--test2.2--test2.3--test2.4;ID=query_1;Name=test2.1
chr1	S-MART	test2.2	300	450	781	+	.	nbOverlaps=3;overlapsWith=test2.1--test2.2--test2.3;ID=query_2;Name=test2.2
chr1	S-MART	test2.3	480	800	321	+	.	nbOverlaps=1;overlapsWith=test2.1;ID=query_3;Name=test2.3
chr1	S-MART	test2.5	850	1000	151	+	.	nbOverlaps=1;overlapsWith=test2.5;ID=query_5;Name=test2.5
""")
        f.close()        

    def _writeExpOutFile_case3(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test3.1	150	250	101	+	.	nbOverlaps=4;overlapsWith=test3.1--test3.2--test3.3--test3.4;ID=query_1;Name=test3.1
chr1	S-MART	test3.2	380	400	21	+	.	nbOverlaps=4;overlapsWith=test3.1--test3.2--test3.3--test3.5;ID=query_2;Name=test3.2
chr1	S-MART	test3.3	480	520	41	+	.	nbOverlaps=1;overlapsWith=test3.1;ID=query_3;Name=test3.3
chr1	S-MART	test3.5	900	950	51	+	.	nbOverlaps=1;overlapsWith=test3.6;ID=query_5;Name=test3.5
""")
        f.close()       

    def _writeExpOutFile_case4(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test4.1	400	500	101	+	.	nbOverlaps=3;overlapsWith=test4.1--test4.2--test4.3;ID=query_1;Name=test4.1
chr1	S-MART	test4.2	450	600	151	+	.	nbOverlaps=3;overlapsWith=test4.1--test4.2--test4.3;ID=query_2;Name=test4.2
chr1	S-MART	test4.3	700	800	101	+	.	nbOverlaps=2;overlapsWith=test4.1--test4.2;ID=query_3;Name=test4.3
""")
        f.close()      

    def _writeExpOutFile_case5(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1	S-MART	test5.1	850	950	101	+	.	nbOverlaps=1;overlapsWith=test4.1;ID=query_1;Name=test5.1\n")
        f.close()      

    def _writeExpOutFile_case6(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test6.1	200	300	101	+	.	nbOverlaps=2;overlapsWith=test6.1--test6.2;ID=query_1;Name=test6.1
chr1	S-MART	test6.2	800	900	101	+	.	nbOverlaps=2;overlapsWith=test6.1--test6.5;ID=query_2;Name=test6.2
""")
        f.close() 

    def _writeExpOutFile_case7(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test7.1	530	550	21	+	.	nbOverlaps=1;overlapsWith=test6.1;ID=query_1;Name=test7.1
chr1	S-MART	test7.2	600	700	101	+	.	nbOverlaps=1;overlapsWith=test6.1;ID=query_2;Name=test7.2
chr1	S-MART	test7.3	650	900	251	+	.	nbOverlaps=2;overlapsWith=test6.1--test6.5;ID=query_3;Name=test7.3
""")
        f.close() 

    def _writeExpOutFile_case8(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test8.1	500	600	101	+	.	nbOverlaps=1;overlapsWith=test8.1;ID=query_1;Name=test8.1
chr1	S-MART	test8.2	700	800	101	+	.	nbOverlaps=1;overlapsWith=test8.1;ID=query_2;Name=test8.2
chr1	S-MART	test8.3	900	1100	201	+	.	nbOverlaps=1;overlapsWith=test8.1;ID=query_3;Name=test8.3
""")
        f.close() 

    def _writeExpOutFile_case9(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test9.1	400	500	101	+	.	nbOverlaps=1;overlapsWith=test9.1;ID=query_1;Name=test9.1
chr1	S-MART	test9.2	550	650	101	+	.	nbOverlaps=2;overlapsWith=test9.1--test9.2;ID=query_2;Name=test9.2
""")
        f.close() 

    def _writeExpOutFile_case10(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test10.1	700	800	101	+	.	nbOverlaps=1;overlapsWith=test10.1;ID=query_1;Name=test10.1
chr1	S-MART	test10.2	900	1000	101	+	.	nbOverlaps=1;overlapsWith=test10.1;ID=query_2;Name=test10.2
chr1	S-MART	test10.3	1100	1300	201	+	.	nbOverlaps=1;overlapsWith=test10.5;ID=query_3;Name=test10.3
""")
        f.close()

    def _writeExpOutFile_case11(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test11.1	420	480	61	+	.	nbOverlaps=1;overlapsWith=test11.1;ID=query_1;Name=test11.1
chr1	S-MART	test11.2	450	715	266	+	.	nbOverlaps=3;overlapsWith=test11.1--test11.4--test11.5;ID=query_2;Name=test11.2
""")
        f.close()
        
    def _writeExpOutFile_case12(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	test12.1	200	400	.	+	.	nbOverlaps=3;overlapsWith=test12.1--test12.2--test12.3;ID=query_1;Name=test12.1
chr1	S-MART	test12.2	600	900	.	+	.	nbOverlaps=2;overlapsWith=test12.1--test12.4;ID=query_2;Name=test12.2
chr1	S-MART	test12.3	700	1000	.	+	.	nbOverlaps=2;overlapsWith=test12.1--test12.4;ID=query_3;Name=test12.3
""")
        f.close()
        
    def _writeQueryGff3File2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1\t1100\t1150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest2\t1250\t1300\t781\t+\t.\tID=query_2;Name=test1.2\n")
        f.close()
        
    def _writeQueryGff3File(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=query_1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t+\t.\tID=query_2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t+\t.\tID=query_3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=query_4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=query_5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=query_6;Name=test1.6\n")
        f.close()
        
    def _writeQueryGff3File_case2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest2.1\t150\t300\t151\t+\t.\tID=query_1;Name=test2.1\n")
        f.write("chr1\tquery\ttest2.2\t300\t450\t781\t+\t.\tID=query_2;Name=test2.2\n")
        f.write("chr1\tquery\ttest2.3\t480\t800\t321\t+\t.\tID=query_3;Name=test2.3\n")
        f.write("chr1\tquery\ttest2.4\t560\t800\t241\t+\t.\tID=query_4;Name=test2.4\n")
        f.write("chr1\tquery\ttest2.5\t850\t1000\t151\t+\t.\tID=query_5;Name=test2.5\n")
        f.close()
        
    def _writeQueryGff3File_case3(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest3.1\t150\t250\t101\t+\t.\tID=query_1;Name=test3.1\n")
        f.write("chr1\tquery\ttest3.2\t380\t400\t21\t+\t.\tID=query_2;Name=test3.2\n")
        f.write("chr1\tquery\ttest3.3\t480\t520\t41\t+\t.\tID=query_3;Name=test3.3\n")
        f.write("chr1\tquery\ttest3.4\t510\t700\t191\t+\t.\tID=query_4;Name=test3.4\n")
        f.write("chr1\tquery\ttest3.5\t900\t950\t51\t+\t.\tID=query_5;Name=test3.5\n")
        f.close()
        
    def _writeQueryGff3File_case4(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest4.1\t400\t500\t101\t+\t.\tID=query_1;Name=test4.1\n")
        f.write("chr1\tquery\ttest4.2\t450\t600\t151\t+\t.\tID=query_2;Name=test4.2\n")
        f.write("chr1\tquery\ttest4.3\t700\t800\t101\t+\t.\tID=query_3;Name=test4.3\n")
        f.close()
        
    def _writeQueryGff3File_case5(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest5.1\t850\t950\t101\t+\t.\tID=query_1;Name=test5.1\n")
        f.close()
        
    def _writeQueryGff3File_case6(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest6.1\t200\t300\t101\t+\t.\tID=query_1;Name=test6.1\n")
        f.write("chr1\tquery\ttest6.2\t800\t900\t101\t+\t.\tID=query_2;Name=test6.2\n")
        f.close()
        
    def _writeQueryGff3File_case7(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest7.1\t530\t550\t21\t+\t.\tID=query_1;Name=test7.1\n")
        f.write("chr1\tquery\ttest7.2\t600\t700\t101\t+\t.\tID=query_2;Name=test7.2\n")
        f.write("chr1\tquery\ttest7.3\t650\t900\t251\t+\t.\tID=query_3;Name=test7.3\n")
        f.close()
        
    def _writeQueryGff3File_case8(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest8.1\t500\t600\t101\t+\t.\tID=query_1;Name=test8.1\n")
        f.write("chr1\tquery\ttest8.2\t700\t800\t101\t+\t.\tID=query_2;Name=test8.2\n")
        f.write("chr1\tquery\ttest8.3\t900\t1100\t201\t+\t.\tID=query_3;Name=test8.3\n")
        f.write("chr1\tquery\ttest8.4\t1200\t1300\t101\t+\t.\tID=query_4;Name=test8.4\n")
        f.close()
        
    def _writeQueryGff3File_case9(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest9.1\t400\t500\t101\t+\t.\tID=query_1;Name=test9.1\n")
        f.write("chr1\tquery\ttest9.2\t550\t650\t101\t+\t.\tID=query_2;Name=test9.2\n")
        f.close()
        
    def _writeQueryGff3File_case10(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest10.1\t700\t800\t101\t+\t.\tID=query_1;Name=test10.1\n")
        f.write("chr1\tquery\ttest10.2\t900\t1000\t101\t+\t.\tID=query_2;Name=test10.2\n")
        f.write("chr1\tquery\ttest10.3\t1100\t1300\t201\t+\t.\tID=query_3;Name=test10.3\n")
        f.close()
        
    def _writeQueryGff3File_case11(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest11.1\t420\t480\t61\t+\t.\tID=query_1;Name=test11.1\n")
        f.write("chr1\tquery\ttest11.2\t450\t715\t266\t+\t.\tID=query_2;Name=test11.2\n")
        f.close()
        
    def _writeQueryGff3File_case12(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest12.1\t200\t400\t.\t+\t.\tID=query_1;Name=test12.1\n")
        f.write("chr1\tquery\ttest12.2\t600\t900\t.\t+\t.\tID=query_2;Name=test12.2\n")
        f.write("chr1\tquery\ttest12.3\t700\t1000\t.\t+\t.\tID=query_3;Name=test12.3\n")
        f.close()
        
    def _writeGFF3File(self, fileName):
        f = open(fileName, "w")
        f.write("chr1\ttest\ttest2.1\t9\t1000\t1001\t+\t.\tID=test2.1;Name=test2.1\n")
        f.write("chr1\ttest\ttest2.2\t50\t350\t301\t+\t.\tID=test2.2;Name=test2.2\n")
        f.write("chr1\ttest\ttest2.3\t100\t600\t501\t+\t.\tID=test2.3;Name=test2.3\n")
        f.write("chr1\ttest\ttest2.4\t200\t450\t251\t+\t.\tID=test2.4;Name=test2.4\n")
        f.write("chr1\ttest\ttest2.5\t700\t950\t251\t+\t.\tID=test2.5;Name=test2.5\n")
        f.write("chr1\ttest\ttest2.6\t800\t900\t101\t+\t.\tID=test2.6;Name=test2.6\n")
        f.write("chr1\ttest\ttest2.7\t1200\t1300\t101\t+\t.\tID=test2.7;Name=test2.7\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
