#! /usr/bin/env python
import sys
import MySQLdb
import os.path
from mySql.mySqlQuery import *


class MySqlConnection(object):
  """Connection to a database"""

  def __init__(self, verbosity = 0):
    self.verbosity = verbosity

    self.findConfFile()
    confFile = open(self.confFileName)

    for line in confFile:
      line = line.strip()
      if line == "":
        continue
      if line[0] == "#":
        continue
      words     = line.split("=")
      leftWord  = words[0].strip()
      if len(words) == 1:
        rightWord = ""
      else :
        rightWord = words[1].strip()
        
      if leftWord == "user":
        self.user = rightWord
      elif leftWord == "host":
        self.host = rightWord
      elif leftWord == "database":
        self.databaseName = rightWord
      elif leftWord == "password":
        self.password = rightWord
      else:
        sys.exit("Do not understand key in the mySQL configuration file '%s'" % (leftWord))
        
    if self.user == None:
      sys.exit("User is not defined in the mySQL configuration file!")
    if self.databaseName == None:
      sys.exit("Database is not defined in the mySQL configuration file!")
    if self.host == None:
      sys.exit("Host is not defined in the mySQL configuration file!")
    if self.password == None:
      sys.exit("Password is not defined in the mySQL configuration file!")
      
    confFile.close()


  def findConfFile(self):
    self.confFileName = os.path.expanduser(os.path.join("~", ".pythonConnection.txt"))
    if os.path.exists(self.confFileName):
      return
    self.confFileName = os.path.expanduser(os.path.join("~", "pythonConnection.txt"))
    if os.path.exists(self.confFileName):
      return
    self.confFileName = os.path.join("Python", ".pythonConnection.txt")
    if os.path.exists(self.confFileName):
      return
    self.confFileName = os.path.join("Python", "pythonConnection.txt")
    if os.path.exists(self.confFileName):
      return
    self.confFileName = ".pythonConnection.txt"
    if os.path.exists(self.confFileName):
      return
    self.confFileName = "pythonConnection.txt"
    if os.path.exists(self.confFileName):
      return
    if 'SMARTPATH' not in os.environ:
      sys.exit("'SMARTPATH' environment variable is not set! See configuration in the documentation!")
    directory = os.environ['SMARTPATH']
    self.confFileName = os.path.join(directory, ".pythonConnection.txt")
    if os.path.exists(self.confFileName):
      return
    self.confFileName = os.path.join(directory, "pythonConnection.txt")
    if os.path.exists(self.confFileName):
      return
    sys.exit("File '.pythonConnection.txt' is not correctly set in root directory! See configuration in the documentation!")


  def executeQuery(self, command, insertion = False):
    query = MySqlQuery(self.user, self.host, self.password, self.databaseName, self.verbosity)
    query.execute(command, insertion)
    return query


  def removeTable(self, table):
    query = "DROP TABLE IF EXISTS %s" % (table)
    self.executeQuery(query)

