import unittest
import os
from SMART.Java.Python.CollapseReads import CollapseReads
from SMART.Java.Python.misc import Utils
from commons.core.utils.FileUtils import FileUtils
from SMART.Java.Python.ncList.test.MockFindOverlaps_randomExample import MockFindOverlaps_randomExample_NonOrder

class Test_F_CollapseReads(unittest.TestCase):

    def setUp(self):
        self._inputFileName = 'inputCR.gff3'
        self._writeInput(self._inputFileName)
        self._outputFileName = 'outputCR.gff3'
        self._expOutputFileName = 'expOutputCR.gff3'
        
    def tearDown(self):
        return

    def test_run_default_option(self):
        iCR = CollapseReads(0)
        iCR.setInputFile(self._inputFileName, 'gff3')
        iCR.setOutputFile(self._outputFileName)
        iCR.strands = False
        iCR.collapse()
        self._writeExp_strand_False(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
            
    def test_run_strand_option(self):
        iCR = CollapseReads(0)
        iCR.setInputFile(self._inputFileName, 'gff3')
        iCR.setOutputFile(self._outputFileName)
        iCR.strands = True
        iCR.collapse()
        self._writeExp_strand_True(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))
        
    def test_run_asScript_default_option(self):
        cmd = 'python ../CollapseReads.py -i %s -f gff3 -o %s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExp_strand_True(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))    
        
    def test_run_asScript_strand_option(self):
        cmd = 'python ../CollapseReads.py -i %s -f gff3 -o %s -s -v 0' % (self._inputFileName, self._outputFileName)
        os.system(cmd)
        self._writeExp_strand_False(self._expOutputFileName)
        self.assertTrue(Utils.diff(self._expOutputFileName, self._outputFileName))    
        
    def test_run_toOrderGff(self):
        iMRE = MockFindOverlaps_randomExample_NonOrder(self._inputFileName, 'chrom', 10, 1000)    
        iMRE.write()
        iCR = CollapseReads(0)
        iCR.setInputFile(self._inputFileName, 'gff3')
        iCR.setOutputFile(self._outputFileName)
        iCR.strands = False
        iCR.collapse()
        f = open(self._expOutputFileName, "w")
        f.close()
        cmd = 'sort -f -n -k4 -k5.4rn -o %s %s'%(self._expOutputFileName, self._inputFileName)
        os.system(cmd) 

    def _writeInput(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\ttest\tmatch\t6155418\t6155441\t.\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=0;ID=test1/1;identity=100;Name=test1/1\n")
        f.write("chr2\ttest\tmatch\t26303950\t26303981\t.\t+\t.\toccurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1\n")
        f.write("chr3\ttest\tmatch\t28320540\t28320574\t.\t+\t.\toccurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1\n")
        f.write("chr4\ttest\tmatch\t28565007\t28565041\t.\t+\t.\toccurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1\n")
        f.write("chr1\ttest\tmatch\t6155418\t6155441\t.\t+\t.\toccurrence=2;rank=2;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=1;ID=test3/1;identity=50;Name=test3/1\n")
        f.write("chr1\ttest\tmatch\t6155418\t6155441\t.\t-\t.\toccurrence=2;rank=2;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=1;ID=test3/1;identity=50;Name=test3/1\n")
        f.close()

    def _writeExp_strand_False(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	.	-	.	nbElements=3.000000;ID=test3/1;Name=test3/1--test3/1--test1/1
chr2	S-MART	match	26303950	26303981	.	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
chr3	S-MART	match	28320540	28320574	.	+	.	occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1
chr4	S-MART	match	28565007	28565041	.	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1
""")
        f.close()
        
    def _writeExp_strand_True(self, fileName):
        f = open(fileName, 'w')
        f.write("""chr1	S-MART	match	6155418	6155441	.	+	.	nbElements=2.000000;ID=test3/1;Name=test3/1--test1/1
chr1	S-MART	match	6155418	6155441	.	-	.	occurrence=2;rank=2;bestRegion=(self);nbGaps=0;nbOccurrences=1;nbMismatches=1;ID=test3/1;identity=50;Name=test3/1
chr2	S-MART	match	26303950	26303981	.	+	.	occurrence=1;rank=1;bestRegion=(self);nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-1;identity=93;Name=test2/1
chr3	S-MART	match	28320540	28320574	.	+	.	occurrence=2;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=2;ID=test2/1-2;identity=94;Name=test2/1
chr4	S-MART	match	28565007	28565041	.	+	.	occurrence=3;rank=3;bestRegion=chr2:26303950-26303981;nbGaps=0;nbOccurrences=3;nbMismatches=4;ID=test2/1-3;identity=88;Name=test2/1
""")
        f.close()
        
if __name__ == "__main__":
    unittest.main()
