import unittest, os, os.path
from SMART.Java.Python.misc import Utils
SMART_PATH = os.environ["REPET_PATH"] + "/SMART"

class Test_F_trimSequences(unittest.TestCase):

    def setUp(self):
        self._expOutputFileName = "expOutputFile.fasta"
        self._obsOutputFileName = "obsOutputFile.mfa"
        self._inputFileName     = "inputFile.fasta"

    def tearDown(self):
        for fileName in (self._expOutputFileName, self._obsOutputFileName, self._inputFileName):
            if os.path.exists(fileName):
                os.remove(fileName)

    def test_simple(self):
        expOutputFile = open(self._expOutputFileName, "w")
        expOutputFile.write(">sequence1\nTTGCATAGCGCTACGTA\n")
        expOutputFile.close()
        inputFile = open(self._inputFileName, "w")
        inputFile.write(">sequence1\nAGCTCGGGTATTGCATAGCGCTACGTACCCTTTATATC\n")
        inputFile.close()
        os.system("python %s/Java/Python/trimSequences.py -i %s -f fasta -3 CCCTTTATATC -5 AGCTCGGGTA -o %s -v 0" % (SMART_PATH, self._inputFileName, self._obsOutputFileName))
        self.assertTrue(Utils.diff(self._expOutputFileName, self._obsOutputFileName))

if __name__ == "__main__":
    unittest.main()
