import re
import sys
from structure.mapping import *
from parser.mapperParser import *


class MaqParser(MapperParser):
  """A class that parses the output of Maq"""

  def __init__(self, fileName, verbosity = 0):
    super(MaqParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(MaqParser, self).__del__()


  def skipFirstLines(self):
    pass


  def parseLine(self, line):
    m = re.search(r"^\s*(\S+)\s+(\S+)\s+(\d+)\s+([+-])\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\S+)\s*$", line)
    if m == None:
      sys.exit("Line %s does not have the Maq format" % (line))

    mapping = Mapping()

    mapping.targetInterval.setStart(int(m.group(3)))
    mapping.targetInterval.setSize(int(m.group(14)))
    mapping.targetInterval.setChromosome(m.group(2))

    mapping.queryInterval.setStart(1)
    mapping.queryInterval.setSize(int(m.group(14)))
    mapping.queryInterval.setName(m.group(1))

    mapping.setDirection(m.group(4))
    mapping.setSize(int(m.group(14)))
    mapping.setNbMismatches(int(m.group(10)))
    mapping.setRank(1)
    mapping.setNbOccurrences(int(m.group(12)) + int(m.group(13)))

    return mapping
