import unittest
from structure.transcript import *


class TestTranscript(unittest.TestCase):
  
  def setUp(self):
    pass
        

  def tearDown(self):
    pass


  def testGetSize(self):
    transcript1 = Transcript()
    transcript1.setDirection("+")
    transcript1.setStart(2000)
    transcript1.setEnd(3000)
    transcript1.setChromosome("arm_X")

    self.assertEqual(transcript1.getSize(), 1001)
  
    transcript2 = Transcript()
    transcript2.copy(transcript1)
    self.assertEqual(transcript1.getSize(), 1001)

    transcript3 = Transcript()
    transcript3.setDirection("+")
    transcript3.setChromosome("arm_X")

    exon1 = Interval()
    exon1.setDirection("+")
    exon1.setChromosome("arm_X")
    exon1.setStart(100)
    exon1.setEnd(200)
    transcript3.addExon(exon1)

    exon2 = Interval()
    exon2.setDirection("+")
    exon2.setChromosome("arm_X")
    exon2.setStart(300)
    exon2.setEnd(400)
    transcript3.addExon(exon2)

    self.assertEqual(transcript3.getSize(), 202)


  def testExtension5Prime(self):
    transcript1 = Transcript()
    transcript1.setDirection("+")
    transcript1.setStart(2000)
    transcript1.setEnd(3000)
    transcript1.setChromosome("arm_X")
  
    transcript2 = Transcript()
    transcript2.copy(transcript1)
    transcript2.setDirection("-")

    transcript1.extendStart(1000)
    transcript2.extendStart(1000)

    self.assertEqual(transcript1.direction, 1)
    self.assertEqual(transcript1.start, 1000)
    self.assertEqual(transcript1.end, 3000)
    self.assertEqual(transcript1.chromosome, "arm_X")

    self.assertEqual(transcript2.direction, -1)
    self.assertEqual(transcript2.start, 2000)
    self.assertEqual(transcript2.end, 4000)
    self.assertEqual(transcript2.chromosome, "arm_X")


if __name__ == '__main__':
    unittest.main()
