import unittest
import os, os.path, glob
from SMART.Java.Python.GetDifferentialExpression import GetDifferentialExpression


class Test_F_GetDifferentialExpression(unittest.TestCase):

    def setUp(self):
        self.inputFileName1 = "inputFile1.gff3"
        self.inputFileName2 = "inputFile2.gff3"
        self.refFileName    = "refFile.gff3"
        self.outputFileName = "outputFile.gff3"
        self.plotFileName   = "outputFile.png"
         
    def tearDown(self):
        for fileRoot in (self.inputFileName1, self.inputFileName2, self.refFileName, self.outputFileName, self.plotFileName):
            for file in glob.glob("%s*" % (fileRoot)):
                os.remove(file)
        os.remove(".RData")

    def test_run_simple(self):
        handle = open(self.inputFileName1, "w")
        handle.write("chr1\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test1;Name=test1;nbElements=100\n")
        handle.write("chr2\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test2;Name=test2;nbElements=1000\n")
        handle.close()
        handle = open(self.inputFileName2, "w")
        handle.write("chr1\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test1;Name=test1;nbElements=200\n")
        handle.write("chr2\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test2;Name=test2;nbElements=1000\n")
        handle.close()
        handle = open(self.refFileName, "w")
        handle.write("chr1\tSMART\tmRNA\t1000\t2000\t.\t+\t.\tID=test1;Name=test1")
        handle.close()
        differentialExpression = GetDifferentialExpression(0)
        differentialExpression.setInputFile(0, self.inputFileName1, "gff3")
        differentialExpression.setInputFile(1, self.inputFileName2, "gff3")
        differentialExpression.setReferenceFile(self.refFileName, "gff3")
        differentialExpression.setOutputFile(self.outputFileName)
        differentialExpression.setPlotterName(self.plotFileName)
        differentialExpression.setPlotter()
        differentialExpression.getDifferentialExpression()
        differentialExpression.mySqlConnection.deleteDatabase()
        handle = open(self.outputFileName)
        lines = handle.readlines()
        self.assertEquals(len(lines), 1)
        self.assertEquals(lines[0], "chr1\tS-MART\ttranscript\t1000\t2000\t.\t+\t.\tnbReadsCond1=100;nbReadsCond2=200;ID=test1;regulation=up;nbUnnormalizedReadsCond2=200;nbUnnormalizedReadsCond1=100;pValue=6.010045e-08;Name=test1\n")
        self.assertTrue(os.path.exists(self.plotFileName))
        
if __name__ == "__main__":
    unittest.main()

