"""
Some functions about bins
"""

def getMinBin():
  return 3


def getMaxBin():
  return 7


def getBin(start, end):
  for i in range(getMinBin(), getMaxBin() + 1):
    binLevel = 10 ** i
    if int(start / binLevel) == int(end / binLevel):
      return int(i * 10 ** (getMaxBin() + 1) + int(start / binLevel))
  return int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))


def getOverlappingBins(start, end):
  array  = []
  bigBin = int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))
  for i in range(getMinBin(), getMaxBin() + 1):
    binLevel = 10 ** i
    array.append((int(i * 10 ** (getMaxBin() + 1) + int(start / binLevel)), int(i * 10 ** (getMaxBin() + 1) + int(end / binLevel))))
  array.append((bigBin, bigBin))
  return array


def getIterator(maxValue = None):
  if maxValue == None:
    maxValue = 10 ** (getMaxBin() + getMinBin()) - 1
  for i in range(getMinBin(), getMaxBin() + 1):
    binLevel = 10 ** i
    binBit   = i * 10 ** (getMaxBin() + 1)
    for j in range(0, maxValue / binLevel+1):
      yield binBit + j
  yield int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))


def getNbBins(maxValue = None):
  if maxValue == None:
    maxValue = 10 ** (getMaxBin() + getMinBin()) - 1
  nbBins = 0
  for i in range(getMinBin(), getMaxBin() + 1):
    nbBins += maxValue / 10 ** i
  return nbBins + 1
