#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Get the repartition of some elements (# exons per transcripts, # of repetitions of a mapping or # of transcripts in a cluster)"""

from optparse import OptionParser
from SMART.Java.Python.structure.TranscriptContainer import TranscriptContainer
from SMART.Java.Python.misc.RPlotter import RPlotter
from SMART.Java.Python.misc.Progress import Progress
from SMART.Java.Python.misc import Utils
from math import *

if __name__ == "__main__":
    
    # parse command line
    description = "Get Nb v1.0.1: Get the distribution of exons per transcripts, or mapping per read, or transcript per cluster. [Category: Visualization]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",     dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in transcript format given by -f]")
    parser.add_option("-f", "--format",    dest="format",         action="store",                     type="string", help="format of the input file [compulsory] [format: transcript file format]")
    parser.add_option("-o", "--output",    dest="outputFileName", action="store",                     type="string", help="output file [compulsory] [format: output file in png format]")
    parser.add_option("-q", "--query",     dest="query",          action="store",                     type="string", help="query  [compulsory] (# exons, # transcripts) [format: choice (exon, transcript, cluster)]")    
    parser.add_option("-b", "--barplot",   dest="barplot",        action="store_true", default=False,                help="use barplot representation [format: bool] [default: false]")
    parser.add_option("-x", "--xMax",      dest="xMax",           action="store",      default=None,  type="int",    help="maximum value on the x-axis to plot [format: int]")
    parser.add_option("-v", "--verbosity", dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [default: 1] [format: int]")
    parser.add_option("-l", "--log",       dest="log",            action="store_true", default=False,                help="write a log file [format: bool] [default: false]")
    (options, args) = parser.parse_args()

    if options.query != "exon" and options.query != "transcript" and options.query != "cluster":
        raise Exception("Do not understand query %s" % (options.query))

    exonDistribution       = {}
    transcriptDistribution = {}
    clusterDistribution    = {}
    
    transcriptContainer = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
        
    progress = Progress(transcriptContainer.getNbTranscripts(), "Parsing %s" % (options.inputFileName), options.verbosity)
    # count the number of reads
    for element in transcriptContainer.getIterator():
        if options.query == "exon":
            nbExons = element.getNbExons()
            exonDistribution[nbExons] = exonDistribution.get(nbExons, 0) + 1
        elif options.query == "transcript":
            name = element.getName()
            transcriptDistribution[name] = transcriptDistribution.get(name, 0) + 1
        elif options.query == "cluster":
            nbElements = 1 if "nbElements" not in element.getTagNames() else element.getTagValue("nbElements")
            clusterDistribution[nbElements] = clusterDistribution.get(nbElements, 0) + 1
        progress.inc()
    progress.done()
    
    if options.query == "exon":
        distribution = exonDistribution
    elif options.query == "transcript":
        distribution = {}
        for name in transcriptDistribution:
            distribution[transcriptDistribution[name]] = distribution.get(transcriptDistribution[name], 0) + 1
    elif options.query == "cluster":
        distribution = clusterDistribution
    
    outputFileName = options.outputFileName
    plotter = RPlotter(outputFileName, options.verbosity)
    plotter.setImageSize(1000, 300)
    plotter.setFill(0)
    plotter.setMaximumX(options.xMax)
    plotter.setBarplot(options.barplot)
    plotter.addLine(distribution)
    plotter.plot()
             
    print "min/avg/med/max: %d/%.2f/%.1f/%d" % (Utils.getMinAvgMedMax(distribution))
            
