import unittest
from commons.core.parsing.VarscanHit import VarscanHit
from commons.core.checker.CheckerException import CheckerException

class Test_VarscanHit(unittest.TestCase):

    def test_setAttributesFromString(self):
        line = "C02HBa0291P19_LR48\t32\tC\tT\t1\t2\t66,67%\t1\t1\t37\t35\t0.3999999999999999\n"
        
        expChrom = "C02HBa0291P19_LR48"
        expPosition = "32"
        expRef = "C"
        expVar = "T"
        
        varscanHit = VarscanHit()
        varscanHit.setAttributesFromString(line)
        
        obsChrom = varscanHit.getChrom()
        obsPosition = varscanHit.getPosition()
        obsRef = varscanHit.getRef()
        obsVar = varscanHit.getVar()
        
        self.assertEquals(expChrom, obsChrom)
        self.assertEquals(expPosition, obsPosition)
        self.assertEquals(expRef, obsRef)
        self.assertEquals(expVar, obsVar)
        
    def test_setAttributesFromString_empty_chrom(self):
        line = "\t32\tC\tT\t1\t2\t66,67%\t1\t1\t37\t35\t0.3999999999999999\n"
        iVarscanHit = VarscanHit()
        try :
            iVarscanHit.setAttributesFromString(line)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Chrom is empty in varscan file in line "
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def  test_setAttributesFromString_less_than_12_fields(self):
        line = "C02HBa0291P19_LR48\t32\tC\tT\t1\t2\t66,67%\t1\t1\t37\n"
        iVarscanHit = VarscanHit()
        iVarscanHit.setAttributesFromString(line)
        self.assertEquals("", iVarscanHit.getQualVar())
        self.assertEquals("", iVarscanHit.getPValue())
        
    def test_setAttributes(self):
        lResults = ["C02HBa0291P19_LR48", "32", "C", "T", "1", "2", "66,67%", "1", "1", "37", "35", "0.3999999999999999"]
        lineNumber = 1
        
        expChrom = "C02HBa0291P19_LR48"
        expPosition = "32"
        expRef = "C"
        expVar = "T"
        
        varscanHit = VarscanHit()
        varscanHit.setAttributes(lResults, lineNumber)
        
        obsChrom = varscanHit.getChrom()
        obsPosition = varscanHit.getPosition()
        obsRef = varscanHit.getRef()
        obsVar = varscanHit.getVar()
        
        self.assertEquals(expChrom, obsChrom)
        self.assertEquals(expPosition, obsPosition)
        self.assertEquals(expRef, obsRef)
        self.assertEquals(expVar, obsVar)

    def test_setAttributes_empty_chrom(self):
        lResults = ["", "", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 1
        
        varscanHit = VarscanHit()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Chrom is empty in varscan file in line 1"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_position(self):
        lResults = ["chrom", "", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHit()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Position is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_ref(self):
        lResults = ["chrom", "position", "", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHit()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Ref is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test_setAttributes_empty_var(self):
        lResults = ["chrom", "position", "ref", "", "", "", "10", "", "", "", "", ""]
        lineNumber = 5
        
        varscanHit = VarscanHit()
        checkerExceptionInstance = None
        try:
            varscanHit.setAttributes(lResults, lineNumber)
        except CheckerException, e:
            checkerExceptionInstance = e
        
        expMessage = "The field Var is empty in varscan file in line 5"
        obsMessage = checkerExceptionInstance.msg
           
        self.assertEquals(expMessage, obsMessage)

    def test__eq__notEquals(self):
        varscanHit1 = VarscanHit()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('T')
        
        varscanHit2 = VarscanHit()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('34')
        varscanHit2.setRef('A')
        varscanHit2.setVar('T')
        
        self.assertFalse(varscanHit1 == varscanHit2)

    def test__eq__Equals(self):
        varscanHit1 = VarscanHit()
        varscanHit1.setChrom('C02HBa0291P19_LR48')
        varscanHit1.setPosition('32')
        varscanHit1.setRef('C')
        varscanHit1.setVar('T')
        
        varscanHit2 = VarscanHit()
        varscanHit2.setChrom('C02HBa0291P19_LR48')
        varscanHit2.setPosition('32')
        varscanHit2.setRef('C')
        varscanHit2.setVar('T')
        
        self.assertTrue(varscanHit1 == varscanHit2)        

if __name__ == "__main__":
    unittest.main()