#! /usr/bin/env python
#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""Explode wig files into several files, one for each chromosome"""

import os, re, sys
from optparse import OptionParser


if __name__ == "__main__":
    
    # parse command line
    description = "Wig Exploder v1.0.1: Explode a big WIG file into several smaller WIG files (one per chromosome). [Category: Personal]"

    parser = OptionParser(description = description)
    parser.add_option("-i", "--input",                        dest="inputFileName", action="store",                                         type="string", help="input file [compulsory] [format: file in WIG format]")
    parser.add_option("-o", "--output",                     dest="output",                action="store",            default=None,    type="string", help="output directory [compulsory] [format: directory]")
    parser.add_option("-s", "--strand",                     dest="strand",                action="store",            default=None,    type="string", help="strand of the input WIG file (if any) [format: choice (+, -)]")
    parser.add_option("-v", "--verbosity",                dest="verbosity",         action="store",            default=1,         type="int",        help="trace level [format: int]")
    (options, args) = parser.parse_args()

    inputFile = open(options.inputFileName)

    files         = {}
    file            = None
    trackLine = None
    strand        = ""
    if options.strand != None:
        strand = options.strand

    for line in inputFile:
        line = line.strip()

        if line.startswith("track"):
            trackLine = line
            continue

        m1 = re.search(r"^\s*fixedStep\s+chrom=(\S+)\s+start=\d+\s+step=\d+\s*$", line)
        m2 = re.search(r"^\s*fixedStep\s+chrom=(\S+)\s+start=\d+\s+step=\d+\s+span=\d+\s*$", line)
        m3 = re.search(r"^\s*variableStep\s+chrom=(\S+)\s*$", line)
        m4 = re.search(r"^\s*variableStep\s+chrom=(\S+)span=\d+\s*$", line)

        m = None
        if m1 != None:
            m = m1
        elif m2 != None:
            m = m2
        elif m3 != None:
            m = m3
        elif m4 != None:
            m = m4

        if m != None:
            chromosome = m.group(1)

            if chromosome in files:
                file = files[chromosome]
            else:
                file = open("%s%s%s%s.wig" % (options.output, os.sep, chromosome, strand), "w")
                files[chromosome] = file
                if trackLine != None:
                    file.write("%s\n" % (trackLine))

        if file == None:
            sys.exit("Header is missing (current first line is '%s')! Aborting..." % (line))

        file.write("%s\n" % (line))

    inputFile.close()

    for chromosome in files:
        files[chromosome].close()
