import unittest
import os
from commons.core.utils.FileUtils import FileUtils


class Test_F_BlatToGff(unittest.TestCase):


    def test_run(self):
        blatInputFileName = '%s/commons/core/parsing/test/inputFile.tab' % os.environ['REPET_PATH']
        self._writeBlatInputFile(blatInputFileName)
        
        obsOutputFileName = '%s/commons/core/parsing/test/obsOutputFile.tab' % os.environ['REPET_PATH']
        cmd = 'python %s/commons/core/parsing/BlatToGff.py -i %s -o %s' % (os.environ['REPET_PATH'], blatInputFileName, obsOutputFileName)
        os.system(cmd)
        
        expOutputFileName = '%s/commons/core/parsing/test/expOutputFile.tab' % os.environ['REPET_PATH']
        self._writeExpOutputFile(expOutputFileName)
        
        self.assertTrue(FileUtils.are2FilesIdentical(expOutputFileName, obsOutputFileName))
        os.remove(blatInputFileName)
        os.remove(obsOutputFileName)
        os.remove(expOutputFileName)

    def test_run_with_methodName(self):
        blatInputFileName = '%s/commons/core/parsing/test/inputFile.tab' % os.environ['REPET_PATH']
        self._writeBlatInputFile(blatInputFileName)
        
        obsOutputFileName = '%s/commons/core/parsing/test/obsOutputFile.tab' % os.environ['REPET_PATH']
        cmd = 'python %s/commons/core/parsing/BlatToGff.py -i %s -o %s -n Test_F' % (os.environ['REPET_PATH'], blatInputFileName, obsOutputFileName)
        os.system(cmd)
        
        expOutputFileName = '%s/commons/core/parsing/test/expOutputFile.tab' % os.environ['REPET_PATH']
        self._writeExpOutputFile_with_methodName(expOutputFileName)
        
        self.assertTrue(FileUtils.are2FilesIdentical(expOutputFileName, obsOutputFileName))
        os.remove(blatInputFileName)
        os.remove(obsOutputFileName)
        os.remove(expOutputFileName)
    
    def _writeBlatInputFile(self, blatInputFileName):
        file = open(blatInputFileName, 'w')
        file.write('psLayout version 3\n')
        file.write('\n')
        file.write('match    mis-     rep.     N\'s    Q gap    Q gap    T gap    T gap    strand    Q            Q       Q        Q      T            T       T        T      block    blockSizes     qStarts     tStarts\n')
        file.write('         match    match           count    bases    count    bases              name         size    start    end    name         size    start    end    count\n')
        file.write('---------------------------------------------------------------------------------------------------------------------------------------------------------------\n')
        file.write('315\t20\t0\t0\t3\t10\t2\t9\t+\tMRRE1H001H13FM1\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,\n')
        file.write('690\t11\t0\t0\t1\t3\t2\t4\t-\tmachin1\t704\t0\t704\tchr16\t22053297\t21736364\t21737069\t3\t40,647,14,\t0,43,690,\t21736364,21736406,21737055,\n')
        file.write('554\t26\t0\t0\t1\t16\t1\t17\t-\tMRRE1H032F08FM1\t606\t10\t606\tchr11\t19818926\t3725876\t3726473\t2\t553,27,\t10,579,\t3725876,3726446,\n')
        file.write('620\t23\t0\t0\t0\t0\t0\t0\t-\tmachin2\t643\t0\t643\tchr11\t19818926\t3794984\t3795627\t1\t643,\t0,\t3794984,\n')
        file.write('347\t25\t0\t0\t0\t0\t0\t0\t-\tmachin3\t393\t21\t393\tchr18\t29360087\t12067347\t12067719\t1\t372,\t0,\t12067347,\n')
        file.close()
        
    def _writeExpOutputFile(self, expOutputFileName):
        file = open(expOutputFileName, 'w')
        file.write('##gff-version 3\n')
        file.write('chr16\tBlatToGff\tBES\t21686950\t21687294\t.\t+\t.\tID=MRRE1H001H13FM1;Name=MRRE1H001H13FM1;bes_start=21686950;bes_end=21687294;bes_size=22053297\n')
        file.write('chr16\tBlatToGff\tBES\t21736364\t21737069\t.\t+\t.\tID=machin1;Name=machin1;bes_start=21736364;bes_end=21737069;bes_size=22053297\n')
        file.write('chr11\tBlatToGff\tBES\t3725876\t3726473\t.\t+\t.\tID=MRRE1H032F08FM1;Name=MRRE1H032F08FM1;bes_start=3725876;bes_end=3726473;bes_size=19818926\n')
        file.write('chr11\tBlatToGff\tBES\t3794984\t3795627\t.\t+\t.\tID=machin2;Name=machin2;bes_start=3794984;bes_end=3795627;bes_size=19818926\n')
        file.write('chr18\tBlatToGff\tBES\t12067347\t12067719\t.\t+\t.\tID=machin3;Name=machin3;bes_start=12067347;bes_end=12067719;bes_size=29360087\n')
        file.close()
        
    def _writeExpOutputFile_with_methodName(self, expOutputFileName):
        file = open(expOutputFileName, 'w')
        file.write('##gff-version 3\n')
        file.write('chr16\tBlatToGff\tTest_F:BES\t21686950\t21687294\t.\t+\t.\tID=MRRE1H001H13FM1;Name=MRRE1H001H13FM1;bes_start=21686950;bes_end=21687294;bes_size=22053297\n')
        file.write('chr16\tBlatToGff\tTest_F:BES\t21736364\t21737069\t.\t+\t.\tID=machin1;Name=machin1;bes_start=21736364;bes_end=21737069;bes_size=22053297\n')
        file.write('chr11\tBlatToGff\tTest_F:BES\t3725876\t3726473\t.\t+\t.\tID=MRRE1H032F08FM1;Name=MRRE1H032F08FM1;bes_start=3725876;bes_end=3726473;bes_size=19818926\n')
        file.write('chr11\tBlatToGff\tTest_F:BES\t3794984\t3795627\t.\t+\t.\tID=machin2;Name=machin2;bes_start=3794984;bes_end=3795627;bes_size=19818926\n')
        file.write('chr18\tBlatToGff\tTest_F:BES\t12067347\t12067719\t.\t+\t.\tID=machin3;Name=machin3;bes_start=12067347;bes_end=12067719;bes_size=29360087\n')
        file.close()


if __name__ == "__main__":
    unittest.main()