import unittest
from parser.bedParser import *


class TestBedParser(unittest.TestCase):
  
  def setUp(self):
    pass   

  def tearDown(self):
    pass


  def testParser(self):
    parser = BedParser("TestFiles/testBedParser1.bed")

    self.assertEqual(parser.getNbTranscripts(), 1)

    for transcript in parser.getIterator():
      self.assertEqual(transcript.chromosome, "arm_X")
      self.assertEqual(transcript.name, "test1.1")
      self.assertEqual(transcript.start, 1000)
      self.assertEqual(transcript.end, 2999)
      self.assertEqual(transcript.direction, 1)
      self.assertEqual(transcript.getNbExons(), 2)
      exons = transcript.getExons()
      self.assertEqual(exons[0].chromosome, "arm_X")
      self.assertEqual(exons[0].start, 1000)
      self.assertEqual(exons[0].end, 1099)
      self.assertEqual(exons[0].direction, 1)
      self.assertEqual(exons[1].chromosome, "arm_X")
      self.assertEqual(exons[1].start, 2000)
      self.assertEqual(exons[1].end, 2999)
      self.assertEqual(exons[1].direction, 1)


if __name__ == '__main__':
    unittest.main()

