import unittest
from commons.core.parsing.GffParser import GffParser


class Test_GffParser(unittest.TestCase):
    

    def test_Parser(self):
        parser = GffParser("data/testGffParser1.gff3")

        self.assertEqual(parser.getNbTranscripts(), 3)

        cpt = 0
        for transcript in parser.getIterator():
            cpt += 1
            if cpt == 1:
                self.assertEqual(transcript.getChromosome(), "arm_X")
                self.assertEqual(transcript.getName(), "test1")
                self.assertEqual(transcript.getStart(), 1000)
                self.assertEqual(transcript.getEnd(), 2000)
                self.assertEqual(transcript.getDirection(), 1)
                self.assertEqual(transcript.getNbExons(), 1)
                self.assertEqual(transcript.getTagValue("field"), "value1")
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "arm_X")
                self.assertEqual(exons[0].getStart(), 1000)
                self.assertEqual(exons[0].getEnd(), 2000)
                self.assertEqual(exons[0].getDirection(), 1)
                self.assertEqual(transcript.getSize(), 1001)
            elif cpt == 2:
                self.assertEqual(transcript.getChromosome(), "arm_X")
                self.assertEqual(transcript.getName(), "test2")
                self.assertEqual(transcript.getStart(), 10000)
                self.assertEqual(transcript.getEnd(), 20000)
                self.assertEqual(transcript.getDirection(), -1)
                self.assertEqual(transcript.getNbExons(), 2)
                self.assertEqual(transcript.getTagValue("field"), "value2")
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "arm_X")
                self.assertEqual(exons[0].getStart(), 10000)
                self.assertEqual(exons[0].getEnd(), 10100)
                self.assertEqual(exons[0].getDirection(), -1)
                self.assertEqual(transcript.getSize(), 9602)
            if cpt == 3:
                self.assertEqual(transcript.getChromosome(), "arm_X")
                self.assertEqual(transcript.getName(), "test1.1")
                self.assertEqual(transcript.getStart(), 1000)
                self.assertEqual(transcript.getEnd(), 2000)
                self.assertEqual(transcript.getDirection(), 1)
                self.assertEqual(transcript.getNbExons(), 1)
                self.assertEqual(transcript.getTagValue("ID"), "test1.1-1")
                exons = transcript.getExons()
                self.assertEqual(exons[0].getChromosome(), "arm_X")
                self.assertEqual(exons[0].getStart(), 1000)
                self.assertEqual(exons[0].getEnd(), 2000)
                self.assertEqual(exons[0].getDirection(), 1)
                self.assertEqual(transcript.getSize(), 1001)


if __name__ == '__main__':
        unittest.main()

