# Copyright INRA (Institut National de la Recherche Agronomique)
# http://www.inra.fr
# http://urgi.versailles.inra.fr
#
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
#
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.


from commons.core.checker.CheckerException import CheckerException

class VarscanHit(object):
    
    def __init__(self, chrom = "", position = "", ref = "", var = "", readsRef = "", readsVar = "", varFreq = "", strandsRef = "", strandsVar = "", qualRef = "", qualVar = "", pValue = ""):
        self._chrom = chrom
        self._position = position
        self._ref = ref
        self._var = var
        self._readsRef = readsRef
        self._readsVar = readsVar
        self._varFreq = varFreq
        self._strandsRef = strandsRef
        self._strandsVar = strandsVar
        self._qualRef = qualRef
        self._qualVar = qualVar
        self._pValue = pValue
        
    ## Equal operator
    #
    # @param o a VarscanFileAnalysis instance
    #    
    def __eq__(self, o):
        return self._chrom == o._chrom and self._position == o._position and self._ref == o._ref and self._var == o._var

    def setChrom(self, chromosome):
        self._chrom = chromosome
    
    def setPosition(self, position):
        self._position = position
    
    def setRef(self, referenceAllele):
        self._ref = referenceAllele
    
    def setVar(self, variantAllele):
        self._var = variantAllele
    
    def setReadsRef(self, readsRef):
        self._readsRef = readsRef
    
    def setReadsVar(self, readsVar):
        self._readsVar = readsVar
        
    def setVarFreq(self, varFreq):
        self._varFreq = varFreq
        
    def setStrandsRef(self, strandsRef):
        self._strandsRef = strandsRef
        
    def setStrandsVar(self, strandsVar):
        self._strandsVar = strandsVar
        
    def setQualRef(self, qualRef):
        self._qualRef = qualRef
        
    def setQualVar(self, qualVar):
        self._qualVar = qualVar
        
    def setPValue(self, pValue):
        self._pValue = pValue
    
    def getChrom(self):
        return self._chrom
    
    def getPosition(self):
        return self._position
    
    def getRef(self):
        return self._ref
    
    def getVar(self):
        return self._var
    
    def getReadsRef(self):
        return self._readsRef
    
    def getReadsVar(self):
        return self._readsVar
    
    def getVarFreq(self):
        return self._varFreq
    
    def getStrandsRef(self):
        return self._strandsRef
    
    def getStrandsVar(self):
        return self._strandsVar
    
    def getQualRef(self):
        return self._qualRef
    
    def getQualVar(self):
        return self._qualVar
    
    def getPValue(self):
        return self._pValue
    
    def getHeader(self):
        return "Chrom\tPosition\tRef\tVar\tReads1\tReads2\tVarFreq\tStrands1\tStrands2\tQual1\tQual2\tPvalue\n"
    
    def getVarscanLine(self):
        return "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n" % (self.getChrom(), self.getPosition(), self.getRef(), self.getVar(), self.getReadsRef(), self.getReadsVar(), self.getVarFreq(), self.getStrandsRef(), self.getStrandsVar(),  self.getQualRef(), self.getQualVar(), self.getPValue())
    
    def setAttributes(self, lResults, iCurrentLineNumber):
        if lResults[0] != '':
            self.setChrom(lResults[0])
        else:
            raise CheckerException ("The field Chrom is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[1] != '':
            self.setPosition(lResults[1])
        else:
            raise CheckerException ("The field Position is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[2] != '':
            self.setRef(lResults[2])
        else:
            raise CheckerException ("The field Ref is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[3] != '':
            self.setVar(lResults[3])
        else:
            raise CheckerException ("The field Var is empty in varscan file in line %s" % iCurrentLineNumber)
        if lResults[4] != '':
            self.setReadsRef(lResults[4])
        if lResults[5] != '':
            self.setReadsVar(lResults[5])
        if lResults[6] != '':
            self.setVarFreq(lResults[6])
        if lResults[7] != '':
            self.setStrandsRef(lResults[7])
        if lResults[8] != '':
            self.setStrandsVar(lResults[8])
        if lResults[9] != '':
            self.setQualRef(lResults[9])
        if lResults[10] != '':
            self.setQualVar(lResults[10])
        if lResults[11] != '':
            self.setPValue(lResults[11])
            
    def setAttributesFromString(self, varscanString, iCurrentLineNumber ="", fieldSeparator ="\t"):
        varscanString = varscanString.rstrip()
        lvarscanStringItem = varscanString.split(fieldSeparator)
        if len(lvarscanStringItem)<12:
            for i in range(len(lvarscanStringItem), 12):
                lvarscanStringItem.append ("")
        self.setAttributes(lvarscanStringItem, iCurrentLineNumber)