#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import os
import random
from commons.core.writer.TranscriptListWriter import TranscriptListWriter


class SamWriter(TranscriptListWriter):
    """
    A class that writes a transcript list into a file with SAM format
    @ivar sizes: estimated sizes of the chromosomes
    @type sizes: dict of string to int
    """


    def __init__(self, fileName, verbosity = 0):
        """
        Constructor
        @param fileName:    name of the file 
        @type fileName:     string
        @param verbosity: verbosity
        @type verbosity:    int
        """
        super(SamWriter, self).__init__(fileName, verbosity)
        self.sizes         = {}
        self.headerWritten = False
        
        
    def close(self):
        """
        Close file (trick to add header)
        """
        super(SamWriter, self).close()
        if self.headerWritten:
            return
        tmpFileName = "tmpFile%d.sam" % (random.randint(0, 100000))
        tmpHandle = open(tmpFileName, "w")
        for chromosome, size in self.sizes.iteritems():
            tmpHandle.write("@SQ\tSN:%s\tLN:%d\n" % (chromosome, size))
        self.handle = open(self.fileName)
        for line in self.handle:
            tmpHandle.write(line)
        tmpHandle.close()
        self.handle.close()
        os.rename(tmpFileName, self.fileName)
        self.headerWritten = True


    @staticmethod
    def getFileFormats():
        """
        Get the format of the file
        """
        return ["sam"]
        
        
    @staticmethod
    def getExtension():
        """
        Get the usual extension for the file
        """
        return "sam"
        
        
    def printTranscript(self, transcript):
        """
        Export the given transcript with GBrowse format
        @param transcript: transcript to be printed
        @type transcript: class L{Transcript<Transcript>}
        @return: a string
        """
        self.sizes[transcript.getChromosome()] = max(transcript.getEnd(), self.sizes.get(transcript.getChromosome(), 0))
        return transcript.printSam()

